-- Create AI Messages Table for Conversation History
-- This table stores all messages in a conversation for continuity
-- Replace {hotel_id} with actual hotel ID (e.g., ce5b015174)

CREATE TABLE IF NOT EXISTS app_{hotel_id}_ai_messages (
    id UUID DEFAULT gen_random_uuid() PRIMARY KEY,
    session_id UUID NOT NULL,
    message TEXT NOT NULL,
    sender VARCHAR(20) NOT NULL CHECK (sender IN ('user', 'assistant')),
    has_attachment BOOLEAN DEFAULT FALSE,
    attachment_info JSONB,
    function_called VARCHAR(100),
    function_args JSONB,
    actions JSONB,
    created_at TIMESTAMP WITH TIME ZONE DEFAULT TIMEZONE('utc'::text, NOW()) NOT NULL
);

-- Create indexes for better query performance
CREATE INDEX IF NOT EXISTS idx_ai_messages_session 
    ON app_{hotel_id}_ai_messages(session_id);

CREATE INDEX IF NOT EXISTS idx_ai_messages_created 
    ON app_{hotel_id}_ai_messages(created_at DESC);

CREATE INDEX IF NOT EXISTS idx_ai_messages_session_created 
    ON app_{hotel_id}_ai_messages(session_id, created_at);

-- Enable Row Level Security
ALTER TABLE app_{hotel_id}_ai_messages ENABLE ROW LEVEL SECURITY;

-- Policy: Allow public read access (guests can see their own conversation)
CREATE POLICY "allow_public_read_ai_messages" 
    ON app_{hotel_id}_ai_messages 
    FOR SELECT 
    USING (true);

-- Policy: Allow service role to insert messages
CREATE POLICY "allow_service_insert_ai_messages" 
    ON app_{hotel_id}_ai_messages 
    FOR INSERT 
    TO service_role
    WITH CHECK (true);

-- Add comment
COMMENT ON TABLE app_{hotel_id}_ai_messages IS 'Stores all AI concierge conversation messages for continuity and history';

-- Example usage:
-- SELECT * FROM app_ce5b015174_ai_messages 
-- WHERE session_id = 'some-uuid' 
-- ORDER BY created_at ASC;